/*********************************************************
Filename		:  lab_addr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Laboratory Physical Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/19/2006.
Comments		:  
**********************************************************/

/**************************************************************
Create sequences for MetaData Laboratory Physical Address table
***************************************************************/
set echo on 
spool lab_addr.log

drop sequence seq_md_lab_addr;

create sequence seq_md_lab_addr
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/**************************************************
Create MetaData  Laboratory Physical Address table
***************************************************/
drop table md_lab_address;

create table md_lab_address
( pk_isn number(12,0),
  addr_is_number number(12,0) not null,
  organization_id VARCHAR(256 char) not null,
  address_type VARCHAR2(256 char) not null,
  address_one_text VARCHAR2(256 char),
  address_two_text VARCHAR2(256 char),
  address_three_text VARCHAR2(256 char),
  address_four_text VARCHAR2(256 char),
  country_code VARCHAR(256 char),
  start_date DATE,
  lab_is_number number(12,0));


alter table md_lab_address
add constraint pk_lab_addr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

commit;

create index ialborgid on md_lab_address(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

/* moved to after insert statement

alter table md_lab_address
add( fk_lab number(12,0));

update md_lab_address la
set fk_lab =(select pk_isn from md_lab lb
              where lb.lab_is_number=la.lab_is_number
              and lb.organization_id = la.organization_id)
where la.lab_is_number is not null;
commit;

create index ialab on md_lab_address(fk_lab)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_address
add constraint fk_md_alab foreign key (fk_lab) references md_lab(pk_isn);

commit;
*/


/*************************************************************
Populate MetaData Laboratory Physical Address table with data.
**************************************************************/
set serveroutput on
declare 
cursor c_lab_addr is 
select TSMADDR_IS_NUMBER,TSMADDR_ORG_ID,TYPE_CODE,LINE_ONE_TEXT,LINE_TWO_TEXT,LINE_THREE_TEXT,LINE_FOUR_TEXT,COUNTRY_CODE,START_DATE ,TSRLAB_IS_NUMBER,TSRLAB_ORG_ID
from storet1.tsmaddr AD,storetw.md_lab LB
where AD.tsrlab_is_number = LB.lab_is_number
and AD.tsrlab_org_id = LB.organization_id;
--and AD.type_code != 'Located at';

begin
  for c_var in c_lab_addr loop
    insert into md_lab_address
    (pk_isn,addr_is_number,organization_id,address_type,address_one_text,address_two_text,address_three_text,address_four_text,country_code,start_date,lab_is_number)
    values
    (seq_md_lab_addr.nextval,c_var.tsmaddr_is_number,c_var.tsmaddr_org_id,c_var.type_code,c_var.line_one_text,c_var.line_two_text,c_var.line_three_text,c_var.line_four_text,c_var.country_code,c_var.start_date,c_var.tsrlab_is_number);
  end loop;
  commit;
end;
/

alter table md_lab_address
add( fk_lab number(12,0));

update md_lab_address la
set fk_lab =(select pk_isn from md_lab lb
              where lb.lab_is_number=la.lab_is_number
              and lb.organization_id = la.organization_id)
where la.lab_is_number is not null;
commit;

create index ialab on md_lab_address(fk_lab)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_lab_address
add constraint fk_md_alab foreign key (fk_lab) references md_lab(pk_isn);

commit;

alter table md_lab_address add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_lab_address add SOURCE_UID NUMBER(20);
commit;

alter table md_lab_address modify addr_is_number number(12,0) null;


spool off;
